#include "dcon.h"
#include <sys/types.h>
#include <pwd.h>

struct mods *head = NULL;

/*
 *  add modification of loc (with val) to list of mods
 */

addmod(val, loc)
int val;
int loc;
{

	register struct mods *p, *q;

	if (head) {
		for (q=head ; q->nextm; q=q->nextm)     /*check thru 2nd*/
		        if (q->loc == loc) {            /* to last item */
				q->currval = val;
				return;
				}

		if (q->loc == loc) {                    /* last item    */
			q->currval = val;
			return;
			}

		p = malloc(sizeof (struct mods));       /* add to list  */
		q->nextm = p;
		p->loc = loc;
		p->initval = peek(map(loc));
		p->currval = val;
		p->nextm = NULL;
		p->prevm = q;
		return;
		}

	else {
		head = malloc(sizeof (struct mods));    /* add 1st item */
		head->loc = loc;                        /* to list      */
		head->initval = peek(map(loc));
		head->currval = val;
		head->nextm = NULL;
		head->prevm = NULL;
		return;
		}
}



/*
 *  save value(s) in specified loc(s)
 */

save(loc)
int loc;
{
	struct mods *m;
	int process;

	process = trace;
	if (head)
		if (loc == ALL_LOCS) {          /* save all locs        */
                        if (process) {          /* poke to disk, not    */
                                offset = trace;         /* address      */
				trace = 0;              /* space        */
			        }
			for (m=head ; m->nextm ; m=m->nextm) {
			        poke(m->currval, map(m->loc));
			        if (m->prevm) free(m->prevm);
			        }
		        poke(m->currval, map(m->loc));  /* last loc     */
		        if (m->prevm) free(m->prevm);
		        free(m);
		        head = NULL;
			if (process) {
			        trace = offset;
			        offset = 0;
			        }
		        }

		else {                          /* save spec loc        */
                        if (process) {          /* poke to disk, not    */
                                offset = trace;         /* address      */
				trace = 0;              /* space        */
			        }
			for (m=head ; m->nextm ; m=m->nextm)
			        if (loc == m->loc) {
			                poke(m->currval, map(m->loc));
					if (m->prevm) {
						m->prevm->nextm = m->nextm;
						m->nextm->prevm = m->prevm;
						free(m);
					        }
					else {
						head = m->nextm;
						m->nextm->prevm = NULL;
						free(m);
					        }
					if (process) {
					        trace = offset;
					        offset = 0;
					        }
			                return;
					}
		        if (loc == m->loc) {           /* last loc      */
			        poke(m->currval, map(m->loc));
			        if (m->prevm) {        /* now first     */
					m->prevm->nextm = NULL;
					free(m);
					}
			        else {                  /* first        */
					head = NULL;
					free(m);
					}
			        }
			if (process) {
			        trace = offset;
			        offset = 0;
			        }
		        }

}



/*
 *  restore value(s) in specified loc(s)
 */

rst(loc)
int loc;
{
	struct mods *m;
	int process;

	process = trace;

	if (process)                            /* poke addr. space only*/
	        if (head)
			if (loc == ALL_LOCS) {
				for (m=head ; m->nextm ; m=m->nextm)
				        poke(m->initval, map(m->loc));
			        poke(m->initval, map(m->loc)); /*lastloc*/
			        }
			else {
				for (m=head ; m->nextm ; m=m->nextm)
				        if (loc == m->loc) {
				                poke(m->initval, map(m->loc));
				                return;
						}
			        if (loc == m->loc)      /* last loc     */
				        poke(m->initval, map(m->loc));
			        }

					        /* always poke disk     */
	if (head)
		if (loc == ALL_LOCS) {          /* restore all locs     */
                        if (process) {          /* poke to disk, not    */
                                offset = trace;         /* address      */
				trace = 0;              /* space        */
			        }
			for (m=head ; m->nextm ; m=m->nextm) {
/*                              addmod(m->initval, m->loc);*/
			        poke(m->initval, map(m->loc));
			        if (m->prevm) free(m->prevm);
			        }
/*                      addmod(m->initval, m->loc);*/
		        poke(m->initval, map(m->loc));  /* last loc     */
		        if (m->prevm) free(m->prevm);
		        free(m);
		        head = NULL;
			if (process) {
			        trace = offset;
			        offset = 0;
			        }
		        }

		else {                          /* restore spec loc     */
                        if (process) {          /* poke to disk, not    */
                                offset = trace;         /* address      */
				trace = 0;              /* space        */
			        }
			for (m=head ; m->nextm ; m=m->nextm)
			        if (loc == m->loc) {
    /*                                  addmod(m->initval, m->loc);*/
			                poke(m->initval, map(m->loc));
					if (m->prevm) {
						m->prevm->nextm = m->nextm;
						m->nextm->prevm = m->prevm;
						free(m);
					        }
					else {
						head = m->nextm;
						m->nextm->prevm = NULL;
						free(m);
					        }
					if (process) {
					        trace = offset;
					        offset = 0;
					        }
			                return;
					}
		        if (loc == m->loc) {            /* last loc     */
/*                              addmod(m->initval, m->loc);*/
			        poke(m->initval, map(m->loc));
			        if (m->prevm) {        /* now first     */
					m->prevm->nextm = NULL;
					free(m);
					}
			        else {                  /* first        */
					head = NULL;
					free(m);
					}
				}
			if (process) {
			        trace = offset;
			        offset = 0;
			        }
		        }

}



/*
 *  get comment information for patched file
 */

getcmt(loc)
int loc;
{
	struct  passwd  *pw, *getpwuid();
	char    *username;
	char    *cmtfile;
	FILE *fp;
	char    buff[MAXLINE];
	char    *ps2;
	struct  cmt     {
		struct  cmt     *c_next;
		char    *c_comment;
	} *c, **ptr;
	struct  cmt     *cmthdr = NULL;
	struct  mods *m;

	cmtfile = calloc(strlen(objname)+4, 1);
	strcpy(cmtfile, objname);
	strcat(cmtfile, ".cmt");
	fp = fopen(cmtfile, "a");
	if (fp == NULL)
		error(0, "can't open comment file");

	if ((username = getlogin()) == NULL) {
		pw = getpwuid(getuid());
		username = pw->pw_name;
	}
	fprintf(fp, "%c%c %s %s", CNTRLCHAR, INFO, username, ctime(time()));

	fprintf(fp, "%c%c Loc\t\tValue\n", CNTRLCHAR, DATA);
	if (head)
		if (loc == ALL_LOCS) {
			for (m=head ; m->nextm ; m=m->nextm)
				fprintf(fp, "   %d\t%d\n", m->loc, m->currval);
			fprintf(fp, "   %d\t%d\n", m->loc, m->currval);
			}
		else {
			for (m=head ; m->nextm ; m=m->nextm)
				if (loc == m->loc)
					fprintf(fp, "   %d\t%d\n", m->loc, m->currval);
			if (loc == m->loc)
				fprintf(fp, "   %d\t%d\n", m->loc, m->currval);
			}

	if ((ps2 = getenv("PS2")) == NULL)
	        ps2 = "> ";
	printf("comments:\n%s", ps2);
	ptr = &cmthdr;
	while (fgets(buff, MAXLINE, stdin) != NULL &&
	    strcmp(buff, ".\n") != 0 &&
	    strcmp(buff, "\n") != 0) {
		c = (struct cmt *) malloc(sizeof(struct cmt));
		c->c_next = NULL;
		c->c_comment = malloc((unsigned) strlen(buff)+1);
		strcpy(c->c_comment, buff);
		*ptr = c;
		ptr = &c->c_next;
		printf("%s", ps2);
		}

	for (c = cmthdr; c != NULL; c = c->c_next)
                fprintf(fp, "%c%c %s", CNTRLCHAR, CMT, c->c_comment);
	fclose(fp);
}



/*
 *  copy program being debugged into a separate file
 */

char buf[BUFSIZ];

copyfile(newfildes)
int newfildes;
{
	int r, w;

	seek(newfildes, 0, 0 );                 /* reset "from" file    */
	while (r = read(newfildes, buf, BUFSIZ)) {
		if (r < 0) {
			error(0, "attempt to read current file failed");
			return;
			}
		w = write(fildes, buf, r);
		if (w < 0) {
			error(0, "attempt to copy into new file failed");
			return;
			}
		}

}
