#include <stdio.h>
#include <sys/param.h>
#include <sgtty.h>

#define MAXWRITE        (64*1024)       /* 64k: maximum write size */

char    area[MAXWRITE];
char    usage[] = "Usage: %s [-f] from to\n";
extern  char    *cmdname;
extern  int     errno;

struct  dsize   {
	int     blks;
	int     blk_trk;
} dsize;

main(argc, argv)
int argc;
char *argv[];
{
	int     fdin;
	int     fdout;
	int     tofdasd = 0;
	int     inback;
	int     outback;
	int     size;
	int     track;
	char    *from;
	char    *to;

	if (argc < 3) {
                fprintf(stderr, usage, cmdname);
		exit(1);
	}
	while (**++argv == '-') {
		argc--;
		switch(*(*argv+1)) {
		case 'f':
			tofdasd = 1;
			break;
		default:
			fprintf(stderr, usage, cmdname);
			exit(1);
		}
	}
	if (argc != 3) {
                fprintf(stderr, usage, cmdname);
		exit(1);
	}
	from = *argv++;
	fdin = open(from, 0);
	if (fdin == -1) {
		fprintf(stderr, "%s: cannot open %s for reading.\n", cmdname, from);
		exit(1);
	}
	to = *argv;
	fdout = open(to, 1);
	if (fdout == -1) {
		fprintf(stderr, "%s: cannot open %s for writing.\n", cmdname, to);
		exit(1);
	}
	if (tofdasd) {
		outback = ioctl(fdout, FASTFORM, &tofdasd);
		if (outback) {
			fprintf(stderr, "%s: -f for use to fast disk devices only\n", cmdname);
			exit(1);
		}
	}
	if (ioctl(fdout, FASTSIZE, &dsize) == 0) {
		track = dsize.blk_trk*BSIZE;
		size = (MAXWRITE/track)*track;
	} else
		size = MAXWRITE;
        while ((inback = read(fdin, area, size)) != 0) {
		if (inback == -1) {
			fprintf(stderr, "%s: read error on %s. Errno %d\n", cmdname, from, errno);
			exit(1);
		}
		if (tofdasd && (inback % tofdasd != 0)) {
			fprintf(stderr, "%s: write to fast disk not track sized\n", cmdname);
			exit(1);
		}
		outback = write(fdout, area, inback);
		if (outback != inback) {
			fprintf(stderr, "%s: write error on %s. Errno %d\n", cmdname, to, errno);
                        fprintf(stderr, "Read %d Write %d errno %d\n", inback, outback, errno);
			exit(1);
		}
	}
	close(fdin);
	close(fdout);
}
