/
/ Function:
/   STRCMP compares s1 and s2, and returns 0 if equal, -1 if s1 < s2,
/   and 1 if s1 > s2.
/
/ Calling Sequence:
/   strcmp(s1, s2) { char *s1, *s2 }
/
	entry   strcmp
	using   strcmp,15
strcmp:
	lr	r0,sp
	s	sp,=f'64'
	stm	0,15,0(sp)
	st	0,52(,sp)
	lr	r12,sp

	l       r5,64(,sp)          / Get s1 address
	l       r6,68(,sp)          / Get s2 address
	l       r4,=v(_strtabl)     / Get trt table address
0:
	trt     0(256,r6),0(r4)     / Scan for null
	bc      8,6f                / CC=0?  No null found
	sr      r1,r6               / Else calc length to compare
	ex      r1,7f               / Execute compare
        bh      3f
        bl      4f
        sr      r0,r0               / Strings are equal
        b       5f
3:
        la      r0,1                / s1 > s2
        b       5f
4:
        l       r0,=f'-1'           / s1 < s2
5:
	lm      r1,r15,4(r12)       / Return
	br      r14
6:
	clc     0(256,r5),0(r6)     / Compare them
	bh      3b
	bl      4b
	la      r5,256(r5)          / Increment addresses
	la      r6,256(r6)
	b       0b                  / Continue scan
7:
	clc     0(,r5),0(r6)        / Model clc 0(0,r5),0(r6)
