/       tr(string, trtbl)
/               char    *string;
/               char    *trtbl;
/
/       returns the number of characters translated
/
	.text
	entry tr
	using   .,r15
tr:
	lr      r0,r13          /save stack pointer
	s       r13,2f          /lower stack
	stm     r0,r15,0(r13)   /save regs
	st      r0,4*13(,r13)   /save stack pointer
	l       r11,0f          /get data base
	b       1f
0:      dc      a(.data)
2:      dc      a(savereg)      /size of reg save area
	using   .data,r11
1:
	sr      r0,r0           /clear char count
	l       r6,4+savereg(,r13)      /get trtbl
	l       r5,0+savereg(,r13)      /get string
loop:
	trt     0(256,r5),lentbl        /try to find null byte
	bnz     done            /found it?
	la      r1,256          /no...set length
	ar      r0,r1           /bump length count
	bctr    r1,0            /reduce length for ex
	ex      r1,trex         /translate these chars
	la      r5,1(r1,r5)     /point to next char
	b       loop
done:
	sr      r1,r5           /determine length
	bz      leave           /if nothing left, time to go
	ar      r0,r1           /bump length count
	bctr    r1,0            /reduce length for ex
	ex      r1,trex         /translate these chars
leave:
	lm      r2,r15,8(r13)   /restore regs
	br      r14
trex:
	tr      0(,r5),0(r6)   /executed translate
savereg =       16*4
	drop
	.data
lentbl:
	dc      xl1'01'         /translate table to
	dc      xl255'00'       /find the null byte
