	subroutine noshft(l1)

c computes the derivative polynomial as the initial h
c polynomial and computes the l1 n-shift h polynomials

	common /global/ p, h, qp, qh, shr, shi, s, t, pv, are,
&		mre, eta, infin, nn
	doublecomplex s, t, pv, p(15), h(15), qp(15), qh(15)
	doubleprecision are, mre, eta, infin, shr(15), shi(15)

	doubleprecision xni

	n = nn-1
	nm1 = n-1
	do 10 i = 1,n
		xni = nn-1
		h(i) = p(i) * dcmplx(xni/n, 0)
10	continue

	do 50 jj = 1, l1
		if (dcabs(h(n)) .le. eta*10.0d0*dcabs(p(n))) goto 30
		t = -p(nn) / h(n)
		do 20 i = 1, nm1
			j = nn-i
			h(j) = p(j) + t*h(j-1)
20		continue
		h(1) = p(1)
		goto 50

c if the constant term is essentially 0, shift h coefficients

30		do 40 i = 1, nm1
			j = nn-i
			h(j) = h(j-1)
40		continue
		h(1) = (0.0d0, 0.0d0)
50	continue
	return
	end
