/ KL-11 driver

klvec	= 60
kladdr	= 177560
quitch	= 174		/ quit char
nkl = 1			/ # KL's
hiwater = 30.
lowater = 10.

ps = 177776

.globl	devkl

i.addr	= i.param
i.mode	= i.param+2
i.ctl	= i.param+4
i.rawiq	= i.param+5
i.caniq	= i.param+6
i.canoq	= i.param+7
i.delct	= i.param+10
i.colct	= i.param+11

devkl:
	klread
	klwrite
	kloread
	klowrite
	klclread
	klclwrite

klwrite:
	mov	r0,r2			/ character
	bic	$!177,r2
1:
	cmp	c.count(r1),$hiwater
	ble	1f
	jsr	pc,sleep
	br	1b
1:
	jsr	pc,ttyoutput
		br 2f			/ no room
	jsr	pc,startkl
	rts	pc
2:
	jsr	pc,timeout
	br	1b

klread:
	movb	i.caniq(r4),r1
	jsr	pc,getc			/ any characters?
		br 2f
	cmpb	r0,$377			/ EOF marker
	beq	3f
	add	$2,(sp)
3:
	rts	pc
2:
	jsr	pc,canon
	br	klread

kloread:
klowrite:
	jsr	pc,ttyopen
	cmpb	i.nused(r4),$1		/ first open?
	bne	1f
	mov	$klvec,r0		/ set up KL vector
	mov	$klkint,(r0)+
	mov	$200,(r0)+
	mov	$klpint,(r0)+
	mov	$200,(r0)+
	mov	$kladdr,i.addr(r4)	/ inode copy of address
	mov	$101,*$kladdr		/ enable first character
	mov	r4,klinode		/ remember inode
1:
	rts	pc

klclread:
klclwrite:
	cmpb	i.nused(r4),$1		/ last open?
	bne	1f
	jsr	pc,ttyclose
	movb	i.dev+1,r0
	asl	r0
	clr	klinode(r0)
1:
	rts	pc

/ start KL output, both at transmitter
/ interrupt and on the top half

startkl:
	mov	i.addr(r4),r3
	tstb	4(r3)			/ KL TPS
	bpl	1f			/ still busy
	tstb	i.ctl(r4)		/ test timeout going on
	bmi	1f
	movb	i.canoq(r4),r1		/ get character
	jsr	pc,getc
		br 1f			/ none
	bmi	2f			/ char is delay
	mov	r0,6(r3)		/ send character
1:
	rts	pc
2:
	negb	r0			/ get pos delay
	bic	$!177,r0
	bisb	$200,i.ctl(r4)		/ note timeout
	jsr	pc,ccall		/ timeout
		br 1f			/ after a few clicks
	rts	pc
1:
	bicb	$200,i.ctl(r4)		/ clear time-out
	br	startkl

/ KL keyboard interrupt

klkint:
	mov	*$ps,klno
	jsr	r0,setisp
	jsr	pc,getkl
	mov	(r3),r0			/ get character
	inc	2(r3)			/ reenable keyboard
	bic	$!177,r0
	cmpb	r0,$quitch		/ quit?
	bne	1f
	mov	$034,r0			/ standard quit
1:
	jsr	pc,ttyinput
	br	klret

/ KL printer interrupt

klpint:
	mov	*$ps,klno
	jsr	r0,setisp
	jsr	pc,getkl
	jsr	pc,startkl
	movb	i.canoq(r4),r1
	cmp	c.count(r1),$lowater
	bge	klret
	jsr	pc,wakeup		/ wake up top half
	br	klret

getkl:
	mov	klno,r4
	bic	$!17,r4			/ get KL #
	asl	r4
	mov	klinode(r4),r4		/ get inode #
	beq	1f			/ error, not open
	cmpb	i.dev(r4),$10.		/ make sure it's a KL
	bne	1f
	mov	i.addr(r4),r3		/ KL address
	rts	pc
1:
	tst	(sp)+
klret:
	jmp	retisp

.bss
klno:	.=.+2
klinode:.=.+[2*nkl]
.text

