#include "astro.h"
char	*solstr[]
{
	"Fall equinox",
	"Winter solstice",
	"Spring equinox",
	"Summer soltice",
};

struct
{
	float	beta;
	int	rta;
	int	dec;
	char	*betstr;
} bettab[]
{
	-0.3572, 231,	50,	"quadrantid",
	 0.7620, 336,	0,	"eta aquarid",
	 1.5497, 260,	-20,	"ophiuchid",
	 2.1324, 315,	-15,	"capricornid",
	 2.1991, 339,	-17,	"delta aquarid",
	 2.2158, 340,	-30,	"pisces australid",
	 2.4331, 46,	58,	"perseid",
	-2.6578, 95,	15,	"orionid",
	-1.8678, 15,	-55,	"phoenicid",
	-1.7260, 113,	32,	"geminid",
	0.
};

search()
{
	register i, j, *p;
	int *q;
	double t;

	for(i=0; objlst[i]; i++) {
		p = objlst[i];
		if(p == &oshad)
			continue;
		t = rise(p);
		if(t >= 0.)
		event("%s rises at ", p->name, 0, t,
			i==0? PTIME: PTIME|DARK);
		t = set(p);
		if(t >= 0.)
		event("%s sets at ", p->name, 0, t,
			i==0? PTIME: PTIME|DARK);
		if(p == &osun) {
			for(j=0; j<4; j++) {
				t = solstice(j);
				if(t >= 0.)
				event("%s at ", solstr[j], 0, t,
					SIGNIF|PTIME);
			}
			for(j=0; bettab[j].beta!=0.; j++) {
				t = betcross(bettab[j].beta);
				if(t >= 0)
				event("%s  meteor shower", bettab[j].betstr, 0, t,
					SIGNIF);
			}
		}
		if(p == &omerc || p == &ovenus) {
			t = melong(p);
			if(t >= 0)
			event("Maximum elongation of %s", p->name, 0, 0.,
				SIGNIF);
		}
		for(j=i; objlst[j]; j++) {
			if(i == j)
				continue;
			q = objlst[j];
			if(p == &omoon || q == &omoon) {
				occult(p, q, 0.);
				if(occ.t3 < 0.)
					continue;
				if(p == &osun || q == &oshad)
				event("Eclipse of %s at ", p->name, 0,
					occ.t3, SIGNIF|PTIME); else
				event("Occulcation of %s at ", q->name, 0,
					occ.t3, SIGNIF|DARK|PTIME);
				continue;
			}
			if(p == &osun) {
				if(q != &omerc && q != &ovenus)
					continue;
				occult(p, q, 0.);
				if(occ.t3 >= 0.)
				event("Transit of %s at ", q->name, 0,
					occ.t3, SIGNIF|LIGHT);
				continue;
			}
			t = dist(&p->point[0], &q->point[0]);
			if(t > 5000.)
				continue;
			event("%s is in the house of %s",
				p->name, q->name, 0., 0);
		}
	}
	if(flags & OCCULT)
		stars();
	if(flags & AZEL)
		satels();
	evflush();
}
