	subroutine plot3d(zfcn,vxa,vya,vza,xposa,yposa,m,n)
	external zfcn
	integer*2 iymax(1024), iymin(1024),jrowx(100),jrowy(100)
	common/plotc/vx,vy,vz,d,dx,dy,xpos,ypos,c1,c2,xscale,
&		yscale,move1,move2,iymax,iymin,ix1,ix2,iy1,iy2,d2
	common/fval/iflag,zvalue(50,50)

	vx = vxa
	vy = vya
	vz = vza
	xpos = xposa
	ypos = yposa
	d2 =vx*vx + vy*vy + vz*vz
	d = sqrt(d2)
	dx = 2. * xpos/(m-1)
	dy = 2. * ypos/(n-1)
	c1 = d/sqrt(vx*vx + vy*vy)
	c2 = c1/d
	xmin = 1.0e36
	ymin = 1.0e36
	xmax = -1.0e36
	ymax = -1.0e36
c
c compute projective coordinates of all sample points
c in order to determine scaling factors and translation
c constants
c
	do 5 j = 1,n
		y = (j-1)*dy-ypos
		yvy = y*vy
		yvx = y*vx
		x = -xpos
		do 7 i = 1,m
			z = zfcn(x,y)
			zvalue(i,j) = z
			r = d2 / (d2-(x*vx + yvy + z*vz))
			xm = r*(yvx - x*vy)
			ym = r*(z-vz)
			if (xm.lt.xmin) xmin = xm
			if (ym.lt.ymin) ymin = ym
			if (xm.gt.xmax) xmax = xm
			if (ym.gt.ymax) ymax = ym
			x = x + dx
7		continue
5	continue
	xscale = 980./(xmax-xmin)
	yscale = 980./(ymax-ymin)
	move1 = 22. - xmin*xscale
	move2 = 22. - (vz+ymin)*yscale
	xscale = xscale/c2
	yscale = yscale/c1
c
c compute coordinates along first row
c
	do 35 i = 1,m
		call coords(i,1,ix1,iy1)
		jrowx(i) = ix1
		jrowy(i) = iy1
35	continue
c
c the algorithm
c
	do 15 i = 1,1024
		iymax(i) = -1
		iymin(i) = 1025
15	continue
c
c draw left edge of surface
c
	ix1 = jrowx(1)
	iy1 = jrowy(1)
	do 25 j = 2, n
		call coords(1,j,ix2,iy2)
		call line(0)
		ix1 = ix2
		iy1 = iy2
25	continue
c
c draw front edge of surface
c
	ix1 = jrowx(1)
	iy1 = jrowy(1)
	do 30 i = 2, m
		ix2 = jrowx(i)
		iy2 = jrowy(i)
		call line(0)
		ix1 = ix2
		iy1 = iy2
30	continue
c
c to draw rest of surface
c each point p(i,j) is connected to p(i-1,j) and p(i,j-1)
c
	do 1000 j = 2,n
		call coords(1,j,ix1,iy1)
		jrowx(1) = ix1
		jrowy(1) = iy1
		do 999 i = 2,m
			call coords(i,j,ix1,iy1)
			ix2 = jrowx(i-1)
			iy2 = jrowy(i-1)
			call line(0)
			ix2 = jrowx(i)
			iy2 = jrowy(i)
			jrowx(i) = ix1
			jrowy(i) = iy1
			call line(0)
999		continue
1000	continue
	end
