#
/* name:
	trap

function:
	system trap and interrupt handler

algorithm:
	get the trap pc and ps out of the comm_blk and put them on stack
	ascertain whether trap was in user or supervisor mode
	do a case on the trap type:
		any supervisor trap:
			panic!
		user (bus, illegal instr, trace, iot, emt or segmentation)
			signal the appropriate error condition
		user (trap - system call entry)
			fetch the arguments and make the call
		kernel queue entry
			call dain_q to process it

parameters:
	traptype	address of trap vector + 4
	r1		users r1
	r0		users r0
	osp		users stack pointer
	opc		space to fill in users pc from comm_blk
	ops		space to fill in users ps from comm_blk

returns:
	having filled in opc and ops from the comm_blk

globals:
	comm_blk

calls:
	printf
	panic
	signal
	issig
	psig
	system calls through sysent
	fuword
	fuiword
	growstack

called by:
	trap in m45.s

history:
	designed and coded by mark Kampe
*/
#define then /* */
#include "../param.h"
#include "../user.h"
#include "../../shared/constants.h"
#include "../../shared/shared.h"

#define EBIT	1
#define SYS	0104400
#define SETD	0170011
#define UMODE	0100000
#define USER	20
char *traps[]
 {	"bus error",
	"illegal instruction",
	"bpt trap",
	"iot trap",
	"power failure",
	"emt trap",
	"trap instruction",
	"segmentation violation",
	"kernel interrupt" };

struct systent
 {	int count;
	int	(*s_call)(); } sysent[];


trap( traptype, r1, r0, osp, opc, ops )
{	register int i;
	register int j;
	register struct sysent *callp;

	/* get the opc and ops from the shared segment */
		opc = comm_blk->c_opc;
		ops = comm_blk->c_ops;

	u.u_ar0 = &r0;

	i = (traptype >> 2) - 2;
	if (ops&UMODE)
	then	i =+ USER;
	switch( i )
	{	case 0:
		case 1:
		case 2:
		case 3:
		case 4:
		case 5:
		case 6:
		case 7:
			 printf( "Supervisor trap ( %s )\r\n" , traps[i] );
			 printf( "pc = %o, ps = %o\r\n" , opc, ops );
			panic( "trap" );

	case 0+USER:	j = SIGBUS;
			break;
	case 1+USER:	j = SIGINS;
			if (fuiword( opc - 2 ) == SETD &&
			    u.u_precautions[SIGINS] == 0 ) then goto out;
			else	break;
	case 2+USER:	j = SIGTRC;
			break;
	case 3+USER:	j = SIGIOT;
			break;
	case 4+USER:	/* power failure, never happen */
	case 5+USER:	j = SIGEMT;
			break;
	case 6+USER:	/* system call entry */
			u.u_error = 0;
			ops =& ~EBIT;
			callp = &sysent[fuiword(opc-2)&077];
			if (callp == sysent) /* indirect */ then
			{	i = fuiword( opc );
				opc =+ 2;
				j = fuword( i );
				if ((j& ~077) != SYS)
					then j = 077; /* illegal */
				callp = &sysent[j&077];
				for(j = 0; j<callp->count; j++)
					u.u_arg[j] = fuword( i =+ 2 );
			}
			else	/* arguments are in i space */
			{	for(j = 0; j<callp->count; j++)
				{	u.u_arg[j] = fuiword(opc);
					opc =+ 2;
				}
			}
			u.u_dirp = u.u_arg[0];
			(*(callp->s_call))();
			if (u.u_error < 100) then
			{	if (u.u_error) then
				{	ops =| EBIT;
					r0 = u.u_error;
				}
				goto out;
			}
			j = SIGSYS;
			break;
	case 7+USER:	/* if (growstack(sp))
				goto out; */
			j = SIGSEG;
			break;

		default: /* something in my queue, me thinks */
			comm_blk->c_nop[0] = 000002; /* rti (to user state) */
			drain_q();
			goto out;
	}
	signal( j );
 out:
	if (issig()) then
		psig();
}
